<!DOCTYPE html>
<html>
<head>
    <title>Import Excel</title>
</head>
<body>
    <h1>Import Excel File</h1>

    @if(session('success'))
        <p style="color:green">{{ session('success') }}</p>
    @endif

    <form action="{{ route('import.excel') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="file" name="file" required>
        <button type="submit">Import</button>
    </form>

@if(isset($rows) && count($rows) > 0)
    <h2>Attendance Summary</h2>
    <table border="1" cellpadding="8">
        <thead>
            <tr>
                <th>Date</th>
                <th>In Time</th>
                <th>Out Time</th>
                <th>Total Worked</th>
                <th>Extra Hours</th>
            </tr>
        </thead>
        <tbody>
            @foreach($rows as $row)
                <tr>
                    <td>{{ $row['date'] }}</td>
                    <td>{{ $row['in_time'] }}</td>
                    <td>{{ $row['out_time'] }}</td>
                    <td>{{ $row['worked'] }}</td>
                    <td>{{ $row['extra_time'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endif
</body>
</html>


