<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Employee Petition</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            color: #333;
            line-height: 1.6;
            padding: 40px;
        }

        h2 {
            text-align: center;
            color: #005BAC;
            border-bottom: 2px solid #005BAC;
            padding-bottom: 10px;
            margin-bottom: 30px;
        }

        h3, h4 {
            color: #005BAC;
            margin-top: 30px;
        }

        ul {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }

        table, th, td {
            border: 1px solid #999;
        }

        th {
            background-color: #f2f2f2;
            text-align: left;
            padding: 10px;
        }

        td {
            padding: 8px 10px;
        }

        p, li {
            font-size: 14px;
        }

        .header-info {
            font-size: 14px;
            margin-bottom: 10px;
        }

        .footer-note {
            margin-top: 40px;
            font-style: italic;
            font-size: 13px;
            color: #666;
        }
    </style>
</head>
<body>

    <h2>Petition: Request for Transparency and Fairness in Allowance and Salary Communication</h2>

    <div class="header-info"><strong>To:</strong>Gaurav Sir & Sumit Sir</div>
    <div class="header-info"><strong>From:</strong> Concerned Employees of <?php echo e($company_name); ?></div>
    <div class="header-info"><strong>Date:</strong> <?php echo e($date); ?></div>

    <h3>Subject: Concern Regarding Withheld Allowance, Salary Transparency, and Future Clarification</h3>

    <p>We, the undersigned employees of <strong><?php echo e($company_name); ?></strong>, wish to formally bring to your attention the following concerns regarding the recent decision about withholding the allowance and the salary structure communicated to us.</p>

    <h4>Background & Concerns:</h4>
    <ul>
        <li><strong>Allowance Communication & Withholding:</strong>  
            <br>As per company practice, we were informed that an allowance is provided every July of the previous financial year. However, this year, the allowance is being withheld on the grounds that sales targets were not achieved. This reason was not communicated to employees in advance or during the period leading up to the allowance.
        </li>
        <li><strong>Impact on Salary Discussion:</strong>  
            <br>In October 2024, during salary negotiations, some of us (e.g., <strong><?php echo e($employee_example); ?></strong>) requested a salary of Rs. 30,000. The final offer given was Rs. 25,000, with the statement that the actual package was Rs. 27,000, considering the allowance. If the allowance was not guaranteed or performance-based, this should have been made explicitly clear at that time.
        </li>
        <li><strong>Unclear Future of Allowance:</strong>  
            <br>It is still not clear whether the allowance will be provided in the next year. We respectfully request the company to clearly communicate whether such allowances will be part of future compensation or not.
        </li>
        <li><strong>Lack of Standard HR Practices:</strong>  
            <br>There is no provision of PF (Provident Fund) in the company. No salary slips are provided to employees, which creates issues for financial documentation and transparency.
        </li>
    </ul>

    <h4>Our Requests:</h4>
    <ul>
        <li>Provide written clarification on the status of the allowance and whether it will be disbursed in the future.</li>
        <li>Ensure transparent salary negotiations in the future where performance-linked components are clearly mentioned.</li>
        <li>Communicate in advance if any allowance or bonus will not be given due to performance issues.</li>
        <li>Start providing salary slips regularly to all employees.</li>
        <li>Initiate PF deductions or explain alternatives being offered to employees.</li>
    </ul>

    <p>We believe these are standard expectations from any professional organization, and fulfilling them will lead to higher employee trust and satisfaction.</p>
    <p>We hope for your kind attention and a positive resolution.</p>

    <h4>Signed by:</h4>
    <table>
        <thead>
            <tr>
                <th>Employee Name</th> 
                <th>Department</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($employee['name']); ?></td>
                <td><?php echo e($employee['department']); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer-note">
        *This petition is a collective concern submitted respectfully for management consideration. All employee names and departments are verified.
    </div>

</body>
</html>
<?php /**PATH /home/demo99pandit/public_html/attandance/resources/views/petition/pdf.blade.php ENDPATH**/ ?>