<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\IOFactory;
    use Carbon\Carbon;
use Exception;
use PDF; // at the top
use Illuminate\Support\Str;


class AttendanceController extends Controller
{

public function showUploadForm() {
    return view('upload');
}

public function uploadMultiple() {
    return view('attendance.m_upload');
}
public function uploadMultipleExcel(Request $request)
{
    $request->validate([
        'attendance_file.*' => 'required|file|mimes:xlsx,xls', 
    ]);

    $allResultsByMonth = [];
    $overallExtraDecimal = 0;
     

    foreach ($request->file('attendance_file') as $file) {
        $data = Excel::toArray([], $file);
        
        $rows = $data[0];
        // return $rows;
        // dd($rows);
        
         $dept = 'N/A';
        $name = 'N/A';
        $dateRange = 'N/A';
     $details = []; // This will store all extracted values


$month = 'N/A';
foreach ($rows as $row) {
    foreach ($row as $index => $cell) {
        if (is_string($cell)) {
            $lowerCell = strtolower($cell);

            // Pick department
            if (Str::contains($lowerCell, 'dept')) {
                $dept = $row[$index + 1] ?? 'N/A';
            }

            // Pick name
            if (Str::contains($lowerCell, 'name')) {
                $name = $row[$index + 1] ?? 'N/A';
            }

            // Pick correct dateRange (only if next cell looks like date range)
            if (Str::contains($lowerCell, 'date')) {
                $next = $row[$index + 1] ?? '';
                if (preg_match('/\d{4}-\d{2}-\d{2}~\d{4}-\d{2}-\d{2}/', $next)) {
                    $dateRange = $next;
                    $month = $this->getMonthInWords($dateRange);
                }
            }
        }
    }
}         
        $results = [];
        $monthExtraDecimal = 0;

        foreach ($rows as $i => $row) {
            try{
            if ($i < 12 || empty($row[0])) continue;

            $date = $row[0];
            // $inDecimal = $row[3] ?? $row[1]?? $row[6] ?? null;
            // $outDecimal = $row[12] ?? $row[10]?? $row[6] ?? $row[8] ??null;
$nonNullValues = array_values(array_filter($row, function($v) {
    return !is_null($v) && is_numeric($v);
}));

        if (count($nonNullValues) < 2) continue;

        $middleIndex = floor(count($nonNullValues) / 2);
        $inDecimal = $nonNullValues[$middleIndex - 1] ?? null;
        $outDecimal = $nonNullValues[$middleIndex] ?? null;
            if (is_null($inDecimal) || is_null($outDecimal)) continue;
            if (!is_numeric($inDecimal) || !is_numeric($outDecimal)) continue;

$inTimeHours = floatval($inDecimal) * 24;
$outTimeHours = floatval($outDecimal) * 24;

            if ($outTimeHours < $inTimeHours) {
    $outTimeHours += 12;
}


            
            
            $worked = $outTimeHours - $inTimeHours;
$extra = max(0, $worked - 9);

$status = 'Full Day';
// $extra = $worked - 9;
if ($worked < 4.5) {
    $status = 'Too Short';
} 
elseif ($worked < 7) {
    $status = 'Half Day';
    $extra = max(0, $worked - 4.5); // Overtime after 4.5 hrs on Half Day
} 

elseif($worked < 9&&$worked >7) {
   // $extra = $worked - 9;
  $status = "Quator";
}

$monthExtraDecimal += $extra;
$overallExtraDecimal += $extra;

$results[] = [
    'date' => $date,
    'in_time' => $this->convertDecimalToTime($inTimeHours),
    'out_time' => $this->convertDecimalToTime($outTimeHours),
    'worked_hours' => $this->convertDecimalToHoursMinutes($worked),
    'extra_hours' => $this->convertDecimalToHoursMinutes($extra),
    'status' => $status,
];


            }catch(\Exception $e){
return $e;

                
            }
        }

        $allResultsByMonth[] = [
            'month' => $month,
            'dept' => $dept,
            'name' => $name,
            'results' => $results,
            'total_extra_hours' => $this->convertDecimalToHoursMinutes($monthExtraDecimal),
                'sort_date' => Carbon::parse('01 ' . $month), // Using 1st of the month for sorting

        ];
        
      
    }

    $overallTotalExtra = $this->convertDecimalToHoursMinutes($overallExtraDecimal);
    $allResultsByMonth = collect($allResultsByMonth)->sortByDesc('sort_date')->values()->toArray();

session([
    'dataByMonth' => $allResultsByMonth,
    'overallTotalExtra' => $overallTotalExtra,
]);

    return view('attendance.m_result', [
        'dataByMonth' => $allResultsByMonth,
        'overallTotalExtra' => $overallTotalExtra,
    ]);
}


public function downloadPdf(Request $request)
{ 
    $dataByMonth = session('dataByMonth');
    $overallTotalExtra = session('overallTotalExtra');
// return $dataByMonth[0]['name'];
 $pdf_name = $dataByMonth[0]['name'];
    $pdf = PDF::loadView('attendance.m_result', compact('dataByMonth', 'overallTotalExtra'));
    // return $pdf->download('attendance_report.pdf');
    return $pdf->download($pdf_name.'.pdf');

    
}


// {
//     $request->validate([
//         'attendance_file.*' => 'required|file|mimes:xlsx,xls',
//     ]);

//     $allResults = [];
//     $totalExtraHoursDecimal = 0;
//     $dept = '';
//     $name = '';
//     $month = '';

//     foreach ($request->file('attendance_file') as $file) {
//         $data = Excel::toArray([], $file);
//         $rows = $data[0];

//         // Assuming department, name, and month are the same in all files
//         $dept = $rows[4][1] ?? $dept;
//         $name = $rows[4][9] ?? $name;
//         $month = $this->getMonthInWords($rows[5][1] ?? '') ?? $month;

//         foreach ($rows as $i => $row) {
//             if ($i < 12 || empty($row[0])) continue;

//             $date = $row[0];
//             $inDecimal = $row[3] ?? null;
//             $outDecimal = $row[12] ?? null;

//             if (is_null($inDecimal) || is_null($outDecimal)) continue;

//             $inTimeHours = $inDecimal * 24;
//             $outTimeHours = $outDecimal * 24;

//             $worked = $outTimeHours - $inTimeHours;
//             $extra = max(0, $worked - 9);

//             $totalExtraHoursDecimal += $extra;

//             $allResults[] = [
//                 'date' => $date,
//                 'in_time' => $this->convertDecimalToTime($inTimeHours),
//                 'out_time' => $this->convertDecimalToTime($outTimeHours),
//                 'worked_hours' => $this->convertDecimalToHoursMinutes($worked),
//                 'extra_hours' => $this->convertDecimalToHoursMinutes($extra),
//             ];
//         }
//     }

//     $totalExtraHours = $this->convertDecimalToHoursMinutes($totalExtraHoursDecimal);

//     return view('attendance.result', [
//         'results' => $allResults,
//         'totalExtraHours' => $totalExtraHours,
//         'dept' => $dept,
//         'name' => $name,
//         'month' => $month,
//     ]);
// }
//-----------------------------------------------------------------------------------------

function convertDecimalToHoursMinutes($decimalHours)
{
    $hours = floor($decimalHours);
    $minutes = round(($decimalHours - $hours) * 60);
    return sprintf('%02d hrs %02d mins', $hours, $minutes);
}
function convertDecimalToTime($decimal)
{
    if ($decimal === null) return '-';
    $hours = floor($decimal);
    $minutes = round(($decimal - $hours) * 60);
    return date("h:i A", mktime($hours, $minutes));
}
function getMonthInWords($dateRange) {
    if (!$dateRange || !str_contains($dateRange, '~')) {
        return null;
    }

    $dates = explode('~', $dateRange);
    $startDate = $dates[0];

    if (!$startDate) {
        return null;
    }

    return date('F Y', strtotime($startDate));
}


public function uploadExcel(Request $request)
{
    $request->validate([
        'attendance_file' => 'required|file|mimes:xlsx,xls',
    ]);

    $data = Excel::toArray([], $request->file('attendance_file'));
    $rows = $data[0];
// dd($rows);
    // Fallback-safe data extraction
    $dept = $rows[4][1] ?? $rows[6][1] ?? 'N/A';
    $name = $rows[4][9] ?? $rows[6][9] ?? 'N/A';
    $month = $this->getMonthInWords($rows[5][1] ?? $rows[7][1] ?? null);

    $totalExtraHoursDecimal = 0;
    $results = [];

    foreach ($rows as $i => $row) {
        if ($i < 12 || empty($row[0])) continue;

        $date = $row[0];
        $inDecimal = $row[3] ?? $row[1] ?? null;
        $outDecimal = $row[12] ?? $row[10] ?? $row[6] ?? null;

        if (is_null($inDecimal) || is_null($outDecimal)) continue;

        $inTimeHours = $inDecimal * 24;
        $outTimeHours = $outDecimal * 24;
        $worked = $outTimeHours - $inTimeHours;
        $extra = max(0, $worked - 9);

        $totalExtraHoursDecimal += $extra;

        $results[] = [
            'date' => $date,
            'in_time' => $this->convertDecimalToTime($inTimeHours),
            'out_time' => $this->convertDecimalToTime($outTimeHours),
            'worked_hours' => $this->convertDecimalToHoursMinutes($worked),
            'extra_hours' => $this->convertDecimalToHoursMinutes($extra),
        ];
    }

    $totalExtraHours = $this->convertDecimalToHoursMinutes($totalExtraHoursDecimal);

    return view('attendance.result', compact('results', 'totalExtraHours', 'dept', 'name', 'month'));
}

/*public function uploadExcel(Request $request)
{
    $data = Excel::toArray([], $request->file('attendance_file'));
    $rows = $data[0];
// dd($rows);

// return ''.$rows[4][0].'';
$dept = $rows[4][1];
$name = $rows[4][9];
$month =$this->getMonthInWords($rows[5][1]);
if($dept==null){
    $dept = $rows[6][1];

}
if($name==null){
$name = $rows[6][9];
    
}
if($month==null){
    $month =$this->getMonthInWords($rows[7][1]);

}
// dd($rows[4][0]);
// dd($rows[4][1]);

// dd($rows[4][8]);
// dd($rows[4][9]);
// dd($rows[4][]);
// dd($rows[4][]);


$totalExtraHoursDecimal = 0;
$results = [];

foreach ($rows as $i => $row) {
    if ($i < 12 || empty($row[0])) continue;

    $date = $row[0];
    
    $inDecimal = $row[3] ?? null;
    //     if($inDecimal==null){
    //         $inDecimal = $row[1] ?? null;

    // }

    $outDecimal = $row[12] ?? null;
    if($outDecimal==null){
            $outDecimal = $row[10] ?? null;

    }
    

    if (is_null($inDecimal) || is_null($outDecimal)) continue;

    $inTimeHours = $inDecimal * 24;
    $outTimeHours = $outDecimal * 24;

    $worked = $outTimeHours - $inTimeHours;
    $extra = max(0, $worked - 9);

    $totalExtraHoursDecimal += $extra;

    $results[] = [
        'date' => $date,
        'in_time' => $this->convertDecimalToTime($inTimeHours),
        'out_time' => $this->convertDecimalToTime($outTimeHours),
        'worked_hours' => $this->convertDecimalToHoursMinutes($worked),
        'extra_hours' => $this->convertDecimalToHoursMinutes($extra),
    ];
}

$totalExtraHours = $this->convertDecimalToHoursMinutes($totalExtraHoursDecimal);

return view('attendance.result', compact('results', 'totalExtraHours','dept','name','month'));
}*/



}






// public function uploadExcel(Request $request)
// {
//     $request->validate([
//         'attendance_file' => 'required|file|mimes:xls,xlsx'
//     ]);

//     // Load the Excel file
//     $file = $request->file('attendance_file');
//     $spreadsheet = Excel::toArray([], $file);
//     // Assuming first sheet, modify if needed
//     $data = $spreadsheet[0];
//     $cleanedData = array_filter(array_map(function ($row) {
//     return array_filter($row, function ($value) {
//         return !is_null($value);
//     });
// }, $data));
// $totalExtraHours = 0;
// // dd($cleanedData);
// // return $cleanedData;

// $extraHours = 0;
// $totalExtraHours = 0;
// $totalExtraMinutes = 0;

// for ($i = 13; $i <= 43; $i++) { // Rows 13 to 43 contain daily data
//     if (!isset($cleanedData[$i])) continue;

//     $row = $cleanedData[$i];

//     // Extract IN-OUT times in railway time format
//     $beforeNoonIn = $row[3] ?? null;
//     $afterNoonOut = $row[12] ?? null;

//     if ($beforeNoonIn !== null && $afterNoonOut !== null) {
//         $totalWorked = $afterNoonOut - $beforeNoonIn;

//         if ($totalWorked > 9) {
//             $extra = $totalWorked - 9;
//             // $extraHours += $extra;
//             $extraMinutes = $this->decimalToTime($extra);
//         $totalExtraHours += $extraMinutes['hours'];
//         $totalExtraMinutes += $extraMinutes['minutes'];

//         }
//     }
    
// }
// return "Total Extra Hours in October: " . $totalExtraHours . " hrs";


// foreach ($cleanedData as $day) {
//     // Ensure the 12th key exists and is a valid number
//     if (isset($day[12]) && is_numeric($day[12])) {
//         $workedHours = floatval($day[12]);
        
//         if ($workedHours > 9) {
//             $extra = $workedHours - 9;
//             $totalExtraHours += $extra;
//         }
//     }
// }

// // echo "Total Extra Hours: " . round($totalExtraHours, 2);

// dd($totalExtraHours);

//     $results = [];
//     $standardWorkMinutes = 540; // Standard 9 hours workday (540 minutes)

//     foreach ($data as $index => $row) {
//         // Skip header rows and unnecessary data
//         if ($index < 11) continue;  // Adjust based on your sheet structure

//         // Time Card Processing (Dates, In/Out times)
//         if ($row[0] && $row[1] === 'Time Card') {
//             // Extract "Before Noon" In and Out times
//             $beforeNoonIn = $row[2] ?? null;
//             $beforeNoonOut = $row[3] ?? null;
            
//             // Extract "After Noon" In and Out times
//             $afterNoonIn = $row[5] ?? null;
//             $afterNoonOut = $row[6] ?? null;

//             $totalWorkedMinutes = 0;

//             // Calculate worked time for before noon shift
//             if ($beforeNoonIn && $beforeNoonOut) {
//                 try {
//                     $start = Carbon::createFromFormat('H:i', date('H:i', strtotime($beforeNoonIn)));
//                     $end = Carbon::createFromFormat('H:i', date('H:i', strtotime($beforeNoonOut)));

//                     if ($start->gt($end)) continue;  // Skip if start time is after end time

//                     $workedMinutes = $end->diffInMinutes($start);
//                     $totalWorkedMinutes += $workedMinutes;
//                 } catch (\Exception $e) {
//                     continue; // Skip row in case of error
//                 }
//             }

//             // Calculate worked time for after noon shift (Overtime)
//             if ($afterNoonIn && $afterNoonOut) {
//                 try {
//                     $start = Carbon::createFromFormat('H:i', date('H:i', strtotime($afterNoonIn)));
//                     $end = Carbon::createFromFormat('H:i', date('H:i', strtotime($afterNoonOut)));

//                     if ($start->gt($end)) continue;  // Skip if start time is after end time

//                     $workedMinutes = $end->diffInMinutes($start);
//                     $totalWorkedMinutes += $workedMinutes;
//                 } catch (\Exception $e) {
//                     continue; // Skip row in case of error
//                 }
//             }

//             // Calculate worked time in hours
//             $worked = gmdate("H:i", $totalWorkedMinutes * 60);

//             // Calculate extra working hours (if worked hours exceed 540 minutes)
//             $extraMinutes = max(0, $totalWorkedMinutes - $standardWorkMinutes);
//             $extraWorked = gmdate("H:i", $extraMinutes * 60);

//             // Store the result
//             $results[] = [
//                 'date' => $row[0], // Assuming the date is in the first column
//                 'worked' => $worked,
//                 'extra' => $extraWorked,
//             ];
//         }
//     }
// dd($results);
//     // Return the results to the view or further processing
//     return view('results', compact('results'));
// }
// public function timeToDecimal($time) {
//     list($hours, $minutes) = explode(':', $time);
//     return $hours + ($minutes / 60);
// }

// // Convert decimal hours to hours and minutes
// public function decimalToTime($decimalHours) {
//     $hours = floor($decimalHours);
//     $minutes = round(($decimalHours - $hours) * 60);
//     return ['hours' => $hours, 'minutes' => $minutes];
// }
