<?php
namespace App\Http\Controllers;
use App\Imports\AttendanceImport;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\YourDataImport;

class ExcelImportController extends Controller
{
    public function showForm()
    {
        return view('import-excel');
    }

    public function importExcel(Request $request)
{
    $request->validate([
        'file' => 'required|mimes:xlsx,xls,csv',
    ]);

    $import = new AttendanceImport;
    Excel::import($import, $request->file('file'));

    $data = $import->processedData;

    return view('import-excel', ['rows' => $data]);
}
}
