<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToArray;
use Carbon\Carbon;

class AttendanceImport implements ToArray
{
    public $processedData = [];

    public function array(array $rows)
    {
        $header = $rows[0];
        unset($rows[0]);

        foreach ($rows as $row) {
            // Replace column indexes based on your Excel structure
            $date      = $row[0] ?? '';
            $inTimeStr = $row[1] ?? '';
            $outTimeStr= $row[2] ?? '';

            try {
                $inTime  = Carbon::createFromFormat('H:i', $inTimeStr);
                $outTime = Carbon::createFromFormat('H:i', $outTimeStr);

                $workedMinutes = $outTime->diffInMinutes($inTime);
                $extraMinutes = max(0, $workedMinutes - (9 * 60));

                $this->processedData[] = [
                    'date'       => $date,
                    'in_time'    => $inTimeStr,
                    'out_time'   => $outTimeStr,
                    'worked'     => gmdate('H:i', $workedMinutes * 60),
                    'extra_time' => gmdate('H:i', $extraMinutes * 60),
                ];
            } catch (\Exception $e) {
                // Skip or log error for malformed time
            }
        }
    }
}
