<!-- FontAwesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Styles -->
<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        margin-bottom: 20px;
    }

    .btn-group {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
        margin-top: 10px;
    }

    .download-btn {
        display: inline-flex;
        align-items: center;
        background: linear-gradient(135deg, #007BFF, #0056b3);
        color: white;
        padding: 10px 20px;
        border-radius: 8px;
        font-weight: 600;
        text-decoration: none;
        font-size: 15px;
        transition: 0.3s ease;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }

    .download-btn i {
        margin-right: 8px;
    }

    .download-btn:hover {
        background: linear-gradient(135deg, #0056b3, #003f7f);
        transform: scale(1.05);
    }

    .legend {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
        margin: 10px 0 10px;
    }

    .legend span {
        padding: 6px 12px;
        border-radius: 4px;
        font-size: 14px;
        font-weight: 500;
    }

    .halfday { background-color: #fff3cd; color: #856404; }
    .quarter { background-color: #cce5ff; color: #004085; }
    .tooshort { background-color: #f8d7da; color: #721c24; }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    th, td {
        padding: 12px 16px;
        border: 1px solid #ddd;
        text-align: center;
    }

    th {
        background-color: #4CAF50;
        color: white;
        font-weight: bold;
    }

    tr:nth-child(even) { background-color: #f9f9f9; }
    tr:hover { background-color: #f1f1f1; }

    .total-row td {
        font-weight: bold;
        background-color: #e0f7e9;
        color: #2e7d32;
    }

    footer {
        text-align: center;
        margin-top: 30px;
        font-weight: bold;
        color: #888;
    }
</style>

<!-- Header -->
<div class="page-header">
    <h2>Total Extra Hours (All Files Combined): {{ $overallTotalExtra }}</h2>
    <div class="btn-group">
        <a href="{{ route('attendance.download.pdf') }}" class="download-btn">
            <i class="fas fa-file-download"></i> Download PDF
        </a>
        <a href="{{ url()->previous() }}" class="download-btn">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
</div>

@if (!empty($dataByMonth) && isset($dataByMonth[0]))
    <p><strong>Name:</strong> {{ $dataByMonth[0]['name'] }} |
       <strong>Department:</strong> {{ $dataByMonth[0]['dept'] }}</p>
@endif

<!-- Legend -->
<div class="legend">
    <span class="halfday" title="Worked less than 9 hours but more than 4.5">Half Day</span>
    <span class="quarter" title="Worked between 4.5 and 6 hours">Quarter</span>
    <!--<span class="tooshort" title="Worked less than 4.5 hours">Too Short</span>-->
</div>

<p style="margin-top: 0;"><strong>Note:</strong> Quarter days are for reference only and <u>not included in total extra hours calculation.</u></p>

<!-- Data Table per Month -->
@foreach ($dataByMonth as $data)
    <hr>
    <h3>Month: {{ $data['month'] }}</h3>
    <p>Name: {{ $data['name'] }} | Department: {{ $data['dept'] }}</p>
    <p><strong>Total Extra Hours for this month:</strong> {{ $data['total_extra_hours'] }}</p>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>In Time</th>
                <th>Out Time</th>
                <th>Worked Hours</th>
                <th>Extra Hours</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data['results'] as $row)
                <tr 
                    @if($row['status'] === 'Half Day') style="background-color: #fff3cd;" 
                    @elseif($row['status'] === 'Too Short') style="background-color: #f8d7da;" 
                    @elseif($row['status'] === 'Quator') style="background-color: #cce5ff;" 
                    @endif
                >
                    <td>{{ $row['date'] }}</td>
                    <td>{{ $row['in_time'] }}</td>
                    <td>{{ $row['out_time'] }}</td>
                    <td>{{ $row['worked_hours'] }}</td>
                    <td>{{ $row['extra_hours'] }}</td>
                    <td>{{ $row['status'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endforeach

<!-- Footer -->
<footer>Developed by Kripal</footer>
