<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

use App\Http\Controllers\ExcelImportController;

Route::get('/import-excel', [ExcelImportController::class, 'showForm']);
Route::post('/import-excel', [ExcelImportController::class, 'importExcel'])->name('import.excel');

use App\Http\Controllers\AttendanceController;

Route::get('/upload', [AttendanceController::class, 'showUploadForm'])->name('upload.form');
Route::post('/upload', [AttendanceController::class, 'uploadExcel'])->name('upload.excel');

Route::get('/download-pdf', [AttendanceController::class, 'downloadPdf'])->name('attendance.download.pdf');

Route::get('/m-upload', [AttendanceController::class, 'uploadMultiple'])->name('upload.form');
Route::post('/m-upload', [AttendanceController::class, 'uploadMultipleExcel'])->name('upload.m_excel');

use App\Http\Controllers\EmlController;

Route::post('/convert-eml', [EmlController::class, 'convert']);
Route::get('/upload-eml', [EmlController::class, 'showForm']);
