<!DOCTYPE html>
<html>
<head>
    <title>Import Excel</title>
</head>
<body>
    <h1>Import Excel File</h1>

    <?php if(session('success')): ?>
        <p style="color:green"><?php echo e(session('success')); ?></p>
    <?php endif; ?>

    <form action="<?php echo e(route('import.excel')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <input type="file" name="file" required>
        <button type="submit">Import</button>
    </form>

<?php if(isset($rows) && count($rows) > 0): ?>
    <h2>Attendance Summary</h2>
    <table border="1" cellpadding="8">
        <thead>
            <tr>
                <th>Date</th>
                <th>In Time</th>
                <th>Out Time</th>
                <th>Total Worked</th>
                <th>Extra Hours</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($row['date']); ?></td>
                    <td><?php echo e($row['in_time']); ?></td>
                    <td><?php echo e($row['out_time']); ?></td>
                    <td><?php echo e($row['worked']); ?></td>
                    <td><?php echo e($row['extra_time']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php endif; ?>
</body>
</html>


<?php /**PATH /home/f2wr0eurtucd/public_html/easybulk.in/resources/views/import-excel.blade.php ENDPATH**/ ?>